<?php
  /**
   * By Uriel
   */
  class ControladorFolios
  {
    /*=============================================
        CREAR FOLIO AL CONFIRMAR LA SOLICITUD
    =============================================*/
     public static function ctrCrearFolio($array, $user_name){
        $tabla = "tbl_folios";
        #verificar el tipo de servicio de la solicitudes
        #generar folio de acuerdo al servicio
        $folio = ModeloFolios::mdlGetUltimoFolio($tabla,$array['serv_descripcion']);
        $statusFolio = 1;
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
          #array para la creacion del folio
          $datos = array('fk_id_solicitud' => $array['id_solicitud'],
                         'fk_id_status_folio' => $statusFolio,
                         'folio_numero' => $folio,
                         'folio_fecha_creado' => $fechaActual,
                         'folio_creado_por' => $user_name,
                         'folio_tipo_servicio' => $array['serv_descripcion']);
        #insertar en tbl_folios campos: fk_id_solicitud, fk_id_status_folio = "1", folio_numero, folio_fecha_creado, folio_creado_por, folio_tipo_servicio
        $respuesta = ModeloFolios::mdlInsertarFolio($tabla, $datos);
        if ($respuesta !== "") {
          $tablaMat = "tbl_materiales";
          $item = "fk_id_solicitud";
          $tablaManoDe = "tbl_mano_de_obra";
          $tablaIndirectos = "tbl_gastos_indirectos";
          $tablaExternos = "tbl_gastos_externos";
          #se obtienen el apartado de materiales, mano de obra, indiractos, Externos
          $materiales = ModeloSolicitudes::mdlMostrarMateriales($tablaMat,$item, $array['id_solicitud']);
          $manoDeObra = ModeloSolicitudes::mdlMostrarManoDeObra($tablaManoDe,$item, $array['id_solicitud']);
          $manoIndirectos = ModeloSolicitudes::mdlMostrarIndirectos($tablaIndirectos,$item, $array['id_solicitud']);
          $manoExternos = ModeloSolicitudes::mdlMostrarExternos($tablaExternos,$item, $array['id_solicitud']);
          #insertar estimacion de costos en requisicion de material
          #fk_id_folio, requiM_descripcion, requiM_solicitante, requiM_cantidad, requiM_importe_mxn, requiM_importe_usd, requiM_total_mxn, requiM_total_usd, requiM_status
          $statusPartida = "Creado";
          $tblRequiMat = "tbl_requi_material";
          foreach ($materiales as $key => $value) {
              $arrayMateriales = array('fk_id_folio' => $respuesta,
                                        'requiM_descripcion' => $value['mat_descripcion'],
                                        'requiM_cantidad' => $value['mat_cantidad'],
                                        'requiM_importe_mxn' => $value['mat_importe'],
                                        'requiM_importe_usd' => $value['mat_importe_dlls'],
                                        'requiM_total_mxn' => $value['mat_total'],
                                        'requiM_total_usd' => $value['mat_total_dlls'],
                                        'requiM_status' => $statusPartida,
                                        'requiM_fecha' => $fechaActual,
                                        'requiM_moneda' => $value['moneda_descripcion'],
                                        'requiM_unidad_medida' => $value['mat_unidadDeMedida']);
            $insertar = ModeloFolios::mdlInsertarRequisicionMaterial($tblRequiMat, $arrayMateriales);
          }
          #fk_id_folio, requiMO_descripcion, requiMO_cantidad, requiMO_importe_mxn,requiMO_importe_usd,requiMO_total_mxn,requiMO_total_usd, requiMO_status, requiMO_fecha
          $tblRequiMO = "tbl_requi_manodeobra";
          foreach ($manoDeObra as $key => $value) {
            $arrayMateriales = array('fk_id_folio' => $respuesta,
                                      'requiMO_descripcion' => $value['mano_descripcion'],
                                      'requiMO_cantidad' => $value['mano_cantidad'],
                                      'requiMO_importe_mxn' => $value['mano_importe'],
                                      'requiMO_importe_usd' => $value['mano_importe_dlls'],
                                      'requiMO_total_mxn' => $value['mano_total'],
                                      'requiMO_total_usd' => $value['mano_total_dlls'],
                                      'requiMO_status' => $statusPartida,
                                      'requiMO_fecha' => $fechaActual,
                                      'requiMO_moneda' => $value['moneda_descripcion'],
                                      'requiMO_unidad_medida' => $value['mano_unidadDeMedida']);
            $insertarMO = ModeloFolios::mdlInsertarRequisicionMano($tblRequiMO, $arrayMateriales);
          }
          #fk_id_folio, adicionalInd_descripcion, adicionalInd_cantidad, adicionalInd_importe_mxn, adicionalInd_importe_usd, adicionalInd_total_mxn,adicionalInd_total_usd, adicionalesInd_fecha
          $statusPartida2 = "Guardado";
          $tblRequiIndi = "tbl_adicional_indirectos";
          foreach ($manoIndirectos as $key => $value) {
            $arrayMateriales = array('fk_id_folio' => $respuesta,
                                      'adicionalInd_descripcion' => $value['ind_descripcion'],
                                      'adicionalInd_cantidad' => $value['ind_cantidad'],
                                      'adicionalInd_importe_mxn' => $value['ind_importe'],
                                      'adicionalInd_importe_usd' => $value['ind_importe_dlls'],
                                      'adicionalInd_total_mxn' => $value['ind_total'],
                                      'adicionalInd_total_usd' => $value['ind_total_dlls'],
                                      'adicionalInd_status' => $statusPartida2,
                                      'adicionalesInd_fecha' => $fechaActual,
                                      'adicionalesInd_moneda' => $value['moneda_descripcion'],
                                      'adicionalesInd_unidad_medida' => $value['ind_unidadDeMedida']);
            $insertarMO = ModeloFolios::mdlInsertarRequisicionIndirectos($tblRequiIndi, $arrayMateriales);
          }
          #fk_id_folio, requiE_descripcion, requiE_cantidad,requiE_importe_mxn,requiE_importe_usd,requiE_total_mxn,requiE_total_usd,requiE_status,requiE_fecha
          $tblRequiExterno = "tbl_requi_externos";
          foreach ($manoExternos as $key => $value) {
            $arrayMateriales = array('fk_id_folio' => $respuesta,
                                      'requiE_descripcion' => $value['ext_descripcion'],
                                      'requiE_cantidad' => $value['ext_cantidad'],
                                      'requiE_importe_mxn' => $value['ext_importe'],
                                      'requiE_importe_usd' => $value['ext_importe_dlls'],
                                      'requiE_total_mxn' => $value['ext_total'],
                                      'requiE_total_usd' => $value['ext_total_dlls'],
                                      'requiE_status' => $statusPartida,
                                      'requiE_fecha' => $fechaActual,
                                      'requiE_moneda' => $value['moneda_descripcion'],
                                      'requiE_unidad_medida' => $value['ext_unidadDeMedida']);
            $insertarMO = ModeloFolios::mdlInsertarRequisicionExternos($tblRequiExterno, $arrayMateriales);
          }
        }
        return $respuesta;
    }
    /*=============================================
        GET ALL FOLIOS
    =============================================*/
    public static function ctrGetFolios($fechaInicial,$fechaFinal,$status,$respon){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlMostrarFolios($tabla,$fechaInicial,$fechaFinal,$status,$respon);
        return $respuesta;
    }
    /*=============================================
        GET ALL MATERIALES REQUERIDOS JOIN tbl_folios
    =============================================*/
    public static function ctrGetMaterialesReales($item,$valor){
        $tabla = "tbl_requi_material";
        $respuesta = ModeloFolios::mdlMostrarMaterialesReales($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
        GET ALL MANO DE OBRA REQUERIDOS JOIN tbl_folios
    =============================================*/
    public static function ctrGetManodeObraReales($item,$valor){
        $tabla = "tbl_requi_manodeobra";
        $respuesta = ModeloFolios::mdlManoDeObraReales($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
        GET ALL INDIRECTOS REQUERIDOS JOIN tbl_folios
    =============================================*/
    public static function ctrGetIndirectosAdicionales($item,$valor){
        $tabla = "tbl_adicional_indirectos";
        $respuesta = ModeloFolios::mdlIndirectosAdicionales($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
        GET ALL EXTERNOS REQUERIDOS JOIN tbl_folios
    =============================================*/
    public static function ctrGetExternosReales($item,$valor){
        $tabla = "tbl_requi_externos";
        $respuesta = ModeloFolios::mdlExternosReales($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
        UPDADTE CAMPO DE NOTAS GENERALES Y CAMBIO DE STATUS 3 'en proceso'
    =============================================*/
    public static function ctrUpdateNotasGenerales($array){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlUpdateNotasGenerales($tabla,$array);
        return $respuesta;
    }
    public static function ctrHistorialMovimientos($array){
      #$folio,$creadoPor,$movimiento,$coment,$modulo
      $tabla = "tbl_historial_movimientos";
      $respuesta = ModeloFolios::mdlInsertarMovimiento($tabla,$array);
      return $respuesta;
    }
    /*=============================================
        UPDADTE CAMPO DE AVANCE Y CAMBIO DE STATUS
    =============================================*/
    public static function ctrUpdateAvanceFolio($array){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlUpdateAvanceFolio($tabla,$array);
        return $respuesta;
    }
    /*=============================================
        UPDADTE a los campos modelo,serie,marca y equipo y CAMBIO DE STATUS
    =============================================*/
    public static function ctrUpdateInfoEquipo($array){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlUpdateInfoEquipo($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE  MANO DE OBRA WHERE id_mano_de_obra
    =============================================*/
    static public function ctrUpdateMaterialAjax($datos){
        $tabla = "tbl_requi_material";
        $respuestaDetalle = ModeloFolios::mdlUpdateMaterialR($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de fk_id_folio
          $suma = ModeloFolios::mdlSumaTotalMaterialMXN($tabla, $datos['fk_id_folio']);

          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalMaterialesUSD($tabla, $datos['fk_id_folio']);
          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalMateriales_mxn' => $suma['total'],
                        'folio_totalMateriales_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesMaterial($tbl,$data);

          #Sumatoria de los totales de cada apartado
          $sumaTotalesFolio_mxn  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesFolio_usd  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesFolio_usd == "ok") {
              return "EditOK";
          }else {
            return $sumaTotalesFolio_usd;
          }
        }
    }

    /*=============================================
      INSERTAR MATERIALES
    =============================================*/
    static public function ctrInsertMaterialesAjax($datos){
        $tabla = "tbl_requi_material";
        $respuestaDetalle = ModeloFolios::mdlInsertMateriales($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
          $suma = ModeloFolios::mdlSumaTotalMaterialMXN($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalMaterialesUSD($tabla, $datos['fk_id_folio']);

          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalMateriales_mxn' => $suma['total'],
                        'folio_totalMateriales_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);

          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesMaterial($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }else {
            return $sumaTotalesSolicitud;
          }
        }
    }
    static public function ctrAplicarGastoMaterialFolio($datos){
      $tabla = "tbl_requi_material";
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
      $suma = ModeloFolios::mdlSumaTotalMaterialMXN($tabla, $datos['fk_id_folio']);
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
      $sumaDlls = ModeloFolios::mdlSumaTotalMaterialesUSD($tabla, $datos['fk_id_folio']);
      #actualizar el campo de total
      $tbl = "tbl_folios";
      $data = array('id_folio' => $datos['fk_id_folio'],
                    'folio_totalMateriales_mxn' => $suma['total'],
                    'folio_totalMateriales_usd' => $sumaDlls['total'],
                    'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
      $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesMaterial($tbl,$data);
      #Sumatoria de los totales de cada apartado
      $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
      #Sumatoria de los totales de cada apartado EN DLLS
      $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
    }
    /*=============================================
      CAMBIA EL STATUS DE LA PARTIDA A 'EN Aprobación'
    =============================================*/
    static public function ctrCambiarStatusPartida($datos){
      if ($datos['modulo'] == "materiales") {
        $tabla = "tbl_requi_material";
        $array = array('id_requi_material' => $datos['id_requi_material'],
                        'requiM_status' => $datos['requiM_status'],
                        'requiM_solicitante' => $datos['historial_creadoPor'],
                        'folio_bandera' => $datos['folio_bandera'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlUpdateStatusMaterial($tabla, $array);
        if ($respuestaDetalle == "ok") {
          $tab = "tbl_folios";
          $changeBandera = ModeloFolios::mdlCambiarStatusBandera($tab, $array);
          if ($changeBandera !== "ok") {
              return $respuestaDetalle ."Error en cambiar status bandera ". $changeBandera;
          }
        }
        return $respuestaDetalle;
      }elseif ($datos['modulo'] == "manoDeObra") {
        $tabla = "tbl_requi_manodeobra";
        $array = array('id_requi_MdeObra' => $datos['id_requi_MdeObra'],
                        'requiMO_status' => $datos['requiMO_status'],
                        'requiMO_solicitante' => $datos['historial_creadoPor'],
                        'folio_bandera' => $datos['folio_bandera'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlUpdateStatusManoDeObra($tabla, $array);
        if ($respuestaDetalle == "ok") {
          $tab = "tbl_folios";
          $changeBandera = ModeloFolios::mdlCambiarStatusBandera($tab, $array);
          if ($changeBandera !== "ok") {
              return $respuestaDetalle ."Error en cambiar status bandera ". $changeBandera;
          }
        }
        return $respuestaDetalle;
      }elseif ($datos['modulo'] == "externos") {
        $tabla = "tbl_requi_externos";
        $array = array('id_requi_externo' => $datos['id_requi_externo'],
                        'requiE_status' => $datos['requiE_status'],
                        'requiE_solicitante' => $datos['historial_creadoPor'],
                        'folio_bandera' => $datos['folio_bandera'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlUpdateStatusExterno($tabla, $array);
        if ($respuestaDetalle == "ok") {
          $tab = "tbl_folios";
          $changeBandera = ModeloFolios::mdlCambiarStatusBandera($tab, $array);
          if ($changeBandera !== "ok") {
              return $respuestaDetalle ."Error en cambiar status bandera ". $changeBandera;
          }
        }
        return $respuestaDetalle;
      }elseif ($datos['modulo'] == "AdicionalIndirecto") {
        $tabla = "tbl_adicional_indirectos";
        $array = array('id_aIndirecto' => $datos['id_aIndirecto'],
                        'adicionalInd_status' => $datos['adicionalInd_status'],
                        'adicionalInd_solicitante' => $datos['historial_creadoPor']);
        $respuestaDetalle = ModeloFolios::mdlUpdateStatusAdicionalIndirecto($tabla, $array);
        return $respuestaDetalle;
      }
    }
    /*=============================================
      INSERTAR MANO DE OBRA
    =============================================*/
    static public function ctrInsertManoDeObraAjax($datos){
        $tabla = "tbl_requi_manodeobra";
        $respuestaDetalle = ModeloFolios::mdlInsertManoDeObra($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
          $suma = ModeloFolios::mdlSumaTotalManoDeObraMXN($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalManoDeObraUSD($tabla, $datos['fk_id_folio']);

          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalManoDeObra_mxn' => $suma['total'],
                        'folio_totalManoDeObra_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);

          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesManoDeObra($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }else {
            return $sumaTotalesSolicitud;
          }
        }
    }
    /*=============================================
      EDITAR PARTIDA DE  MANO DE OBRA WHERE id_mano_de_obra
    =============================================*/
    static public function ctrUpdateManoDeObraAjax($datos){
        $tabla = "tbl_requi_manodeobra";
        $respuestaDetalle = ModeloFolios::mdlUpdateManoDeObraR($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de fk_id_folio
          $suma = ModeloFolios::mdlSumaTotalManoDeObraMXN($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalManoDeObraUSD($tabla, $datos['fk_id_folio']);
          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalManoDeObra_mxn' => $suma['total'],
                        'folio_totalManoDeObra_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesManoDeObra($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesFolio_mxn  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesFolio_usd  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesFolio_usd == "ok") {
              return "EditOK";
          }else {
            return $sumaTotalesFolio_usd;
          }
        }
    }
    static public function ctrAplicarGastoFolio($datos){
      $tabla = "tbl_requi_manodeobra";
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de fk_id_folio
      $suma = ModeloFolios::mdlSumaTotalManoDeObraMXN($tabla, $datos['fk_id_folio']);
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
      $sumaDlls = ModeloFolios::mdlSumaTotalManoDeObraUSD($tabla, $datos['fk_id_folio']);
      #actualizar el campo de total
      $tbl = "tbl_folios";
      $data = array('id_folio' => $datos['fk_id_folio'],
                    'folio_totalManoDeObra_mxn' => $suma['total'],
                    'folio_totalManoDeObra_usd' => $sumaDlls['total'],
                    'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
      $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesManoDeObra($tbl,$data);
      #Sumatoria de los totales de cada apartado
      $sumaTotalesFolio_mxn  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
      #Sumatoria de los totales de cada apartado EN DLLS
      $sumaTotalesFolio_usd  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
    }
    /*=============================================
      INSERTAR indirectos * folio
    =============================================*/
    static public function ctrInsertarIndirectosAjax($datos){
        $tabla = "tbl_adicional_indirectos";
        $respuestaDetalle = ModeloFolios::mdlInsertarIndirectos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloFolios::mdlSumaTotalIndirectos($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloFolios::mdlSumaTotalIndirectosDlls($tabla, $datos['fk_id_folio']);
          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_total_adicionales_mxn' => $suma['total'],
                        'folio_total_adicionales_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);

          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesIndirectos($tbl,$data);

          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }
        }
        else {
          return $respuestaDetalle;
        }
    }
    static public function ctrEditarIndirectosAjax($datos){
        $tabla = "tbl_adicional_indirectos";
        $respuestaDetalle = ModeloFolios::mdlEditIndirectos($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloFolios::mdlSumaTotalIndirectos($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloFolios::mdlSumaTotalIndirectosDlls($tabla, $datos['fk_id_folio']);
          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_total_adicionales_mxn' => $suma['total'],
                        'folio_total_adicionales_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesIndirectos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "EditOK";
          }
        }else {
          return $respuestaDetalle;
        }
    }
    /*=============================================
      EDITAR PARTIDA DE  MANO DE OBRA WHERE id_mano_de_obra
    =============================================*/
    static public function ctrUpdateExternosAjax($datos){
        $tabla = "tbl_requi_externos";
        $respuestaDetalle = ModeloFolios::mdlUpdateExternosR($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de fk_id_folio
          $suma = ModeloFolios::mdlSumaTotalExternoMXN($tabla, $datos['fk_id_folio']);

          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalExternoUSD($tabla, $datos['fk_id_folio']);
          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalExternos_mxn' => $suma['total'],
                        'folio_totalExternos_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesExternos($tbl,$data);
          if ($sumTotalMaterial !== "ok") {
            return $sumTotalMaterial;
          }
          #Sumatoria de los totales de cada apartado
          $sumaTotalesFolio_mxn  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          if ($sumaTotalesFolio_mxn !== "ok") {
            return $sumaTotalesFolio_mxn;
          }
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesFolio_usd  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesFolio_usd == "ok") {
              return "EditOK";
          }else {
            return $sumaTotalesFolio_usd;
          }
        }else {
          return $respuestaDetalle;
        }
    }
    /*=============================================
      INSERTAR MATERIALES
    =============================================*/
    static public function ctrInsertExternosAjax($datos){
        $tabla = "tbl_requi_externos";
        $respuestaDetalle = ModeloFolios::mdlInsertarExternos($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
          $suma = ModeloFolios::mdlSumaTotalExternoMXN($tabla, $datos['fk_id_folio']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloFolios::mdlSumaTotalExternoUSD($tabla, $datos['fk_id_folio']);

          #actualizar el campo de total
          $tbl = "tbl_folios";
          $data = array('id_folio' => $datos['fk_id_folio'],
                        'folio_totalExternos_mxn' => $suma['total'],
                        'folio_totalExternos_usd' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesExternos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }else {
            return $sumaTotalesSolicitud;
          }
        }else {
            return $respuestaDetalle;
        }
    }
    static public function ctrAplicarGastoExternoFolio($datos){
      $tabla = "tbl_requi_externos";
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
      $suma = ModeloFolios::mdlSumaTotalExternoMXN($tabla, $datos['fk_id_folio']);
      #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
      $sumaDlls = ModeloFolios::mdlSumaTotalExternoUSD($tabla, $datos['fk_id_folio']);

      #actualizar el campo de total
      $tbl = "tbl_folios";
      $data = array('id_folio' => $datos['fk_id_folio'],
                    'folio_totalExternos_mxn' => $suma['total'],
                    'folio_totalExternos_usd' => $sumaDlls['total'],
                    'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
      $sumTotalMaterial = ModeloFolios::mdlActualizarTotalesExternos($tbl,$data);
      #Sumatoria de los totales de cada apartado
      $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotales($tbl,$data);
      #Sumatoria de los totales de cada apartado EN DLLS
      $sumaTotalesSolicitud  = ModeloFolios::mdlSumatoriaDeTotalesDlls($tbl,$data);
    }
    /*=============================================
        GET ALL EXTERNOS REQUERIDOS JOIN tbl_folios
    =============================================*/
    public static function ctrGetNotification(){
        #contador en materiales
        $tabla = "tbl_requi_material";
        $item = null;
        $sumM = ModeloFolios::mdlCountadorPartidasM($tabla,$item);
        $tabla2 = "tbl_requi_manodeobra";
        $sumMO = ModeloFolios::mdlCountadorPartidasMO($tabla2,$item);
        $tabla3 = "tbl_requi_externos";
        $sumE = ModeloFolios::mdlCountadorPartidasE($tabla3,$item);
        $sumatoria = (int) $sumM['contador'] + (int) ($sumMO['contador']) + (int) ($sumE['contador']);
        return $sumatoria;
    }
    public static function ctrCambiarStatusFolio($array){
      $tabla = "tbl_folios";
      $status = "False";
      $datos = array('id_folio' => $array['fk_id_folio'],
                     'folio_bandera' => $status);
      #select a las tablas de materiales, mano de obra y externos if(alguno > 1) folio_bandera == true == alguna partida requiere aprobacion
      $tbl1 = "tbl_requi_material";
      $sumM = ModeloFolios::mdlCountadorPartidasM($tbl1,$datos);
      if ($sumM['contador'] > 0) {
        return "ok";
      }else {
          $tbl2 = "tbl_requi_manodeobra";
          $sunMO = ModeloFolios::mdlCountadorPartidasMO($tbl2,$datos);
          if ($sunMO['contador'] > 0) {
            return "ok";
          }else {
            $tbl3 = "tbl_requi_externos";
            $sumE = ModeloFolios::mdlCountadorPartidasE($tbl3,$datos);
            if ($sumE['contador'] > 0) {
              return "ok";
            }else {
              $respuesta = ModeloFolios::mdlCambiarStatusBandera($tabla,$datos);
            }
          }
      }
    }
    /*=============================================
        GET ALL FOLIOS CON PARTIDAS PENDIENTES POR APROBAR
    =============================================*/
    public static function ctrGetFoliosPendientes(){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlMostrarFoliosPendientes($tabla);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA PARTIDA A 'Aprobada'
    =============================================*/
    static public function ctrAprobarORechazarPartida($datos){
      if ($datos['modulo'] == "materiales") {
        $tabla = "tbl_requi_material";
        $array = array('id_requi_material' => $datos['id_requi_material'],
                        'requiM_status' => $datos['requiM_status'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlAprobarPartidaMaterial($tabla, $array);
        return $respuestaDetalle;
      }elseif ($datos['modulo'] == "manoDeObra") {
        $tabla = "tbl_requi_manodeobra";
        $array = array('id_requi_MdeObra' => $datos['id_requi_MdeObra'],
                        'requiMO_status' => $datos['requiMO_status'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlAprobarPartidaManoDeObra($tabla, $array);
        return $respuestaDetalle;
      }elseif ($datos['modulo'] == "externos") {
        $tabla = "tbl_requi_externos";
        $array = array('id_requi_externo' => $datos['id_requi_externo'],
                        'requiE_status' => $datos['requiE_status'],
                        'id_folio' =>$datos['fk_id_folio']);
        $respuestaDetalle = ModeloFolios::mdlAprobarPartidaExterno($tabla, $array);
        return $respuestaDetalle;
      }
    }
    public static function ctrGetComentariosDeRechazo($item,$valor){
      #contador en materiales
      $tabla = "tbl_historial_movimientos";
      $result = ModeloFolios::mdlGetComentariosRechazo($tabla,$item,$valor);
      return $result;
    }
    public static function ctrGetStatusFolio(){
      #contador en materiales
      $tabla = "cat_status_folios";
      $result = ModeloFolios::mdlGetStatusFolio($tabla);
      return $result;
    }
    public static function ctrChangeStatusFolio($datos){
      $tabla = "tbl_folios";
      $result = ModeloFolios::mdlUpdateStatusFolio($tabla,$datos);
      return $result;
    }
    public static function ctrGetHistorialFolio($item,$valor){
      #contador en materiales
      $tabla = "tbl_historial_movimientos";
      $result = ModeloFolios::mdlGetHistorialFolio($tabla,$item,$valor);
      return $result;
    }
    public static function ctrGetFolioRM(){
      $tabla = "tbl_remisiones";
      $result = ModeloFolios::mdlGetUltimoFolioRM($tabla);
      return $result;
    }
    public static function ctrGenerarRM($datos){
      #contador en materiales
      $tabla = "tbl_remisiones";
      $result = ModeloFolios::mdlInsertarRemision($tabla,$datos);
      return $result;
    }
    public static function ctrGetRM($item, $value){
      $tabla = "tbl_remisiones";
      $result = ModeloFolios::mdlGetRM($tabla,$item,$value);
      return $result;
    }
    public static function ctrUpdateStatuFolio($datos){
      $tabla = "tbl_folios";
      $result = ModeloFolios::mdlUpdateStatusFolio($tabla,$datos);
      return $result;
    }
    public static function ctrUpdateNoFactura($datos){
      $tabla = "tbl_folios";
      $result = ModeloFolios::mdlUpdateNoFactura($tabla,$datos);
      return $result;
    }
    public static function ctrUpdateNoFacturaConStatus($datos){
      $tabla = "tbl_folios";
      $result = ModeloFolios::mdlUpdateNoFacturaConStatus($tabla,$datos);
      return $result;
    }
    public static function ctrMostrarStatus($item,$value){
      $tabla = "cat_status_folios";
      $result = ModeloFolios::mdlGetStatus($tabla,$item,$value);
      return $result;
    }
    public static function ctrGetFoliosAJAX($item,$valor){
        $tabla = "tbl_folios";
        $respuesta = ModeloFolios::mdlMostrarFoliosAjax($tabla,$item,$valor);
        return $respuesta;
    }
  }
 ?>
