<?php
/**
 * By Uriel
 */

require_once "../controllers/folios.controller.php";
require_once "../controllers/solicitudes.controller.php";
require_once "../models/solicitudes.model.php";
require_once "../models/folios.model.php";
  class AjaxFolio{
    /*==================================
      name
    ==================================*/
    public $datos;
    public $dato;
    public function ajaxGetFolios(){
        $item = null;
        $valor = null;
        $respuesta = ControladorFolios::ctrGetFoliosAJAX($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetDatosDeSolicitud(){
        $item = "id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetFoliosAJAX($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetConceptos(){
        $item = "fk_id_solicitud";
        $valor = $this->dato;
        $respuesta = ControladorSolicitudes::ctrGetConceptos($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetMaterialesReales(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetMaterialesReales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetManoDeObraReales(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetManodeObraReales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetIndirectosAdicionales(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetIndirectosAdicionales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetExternosReales(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetExternosReales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxUpdateNotasGenerales(){
        $array = json_decode($this->datos, true);
        $status = 3;
        $movimiento = "Asignación de notas generales";
        $modulo = "folioAdmin";
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $datos = array('id_folio' => $array['id_folio'],
                        'folio_notas_generales' => $array['folio_notas_generales'],
                        'fk_id_status_folio' => $status,
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $array['folio_notas_generales'],
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo,
                        'fk_id_folio' => $array['id_folio']);
        $respuesta = ControladorFolios::ctrUpdateNotasGenerales($datos);
        if ($respuesta == "ok") {
          #insertar Log en tbl_historial_movimientos
          $log = ControladorFolios::ctrHistorialMovimientos($datos);
          echo json_encode($log);
        }else {
            echo json_encode($respuesta);
        }
    }
    public function ajaxUpdateAvanceFolio(){
        $array = json_decode($this->datos, true);

        $movimiento = "Cambio de avance en el folio";
        $modulo = "folioAdmin";
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $status;
        $coment = "Avance del folio a" ." ". $array['folio_avance'] . "%";
        #obtener el status actual del folio
        $item = "id_folio";

        $statusActual = ControladorFolios::ctrGetFoliosAJAX($item,$array['id_folio']);
        if ($statusActual['fk_id_status_folio'] == "1" || $statusActual['fk_id_status_folio'] == "2" || $statusActual['fk_id_status_folio'] == "4") {
            $status = 3;

        }else {
          $status = $statusActual['fk_id_status_folio'];
        }
        if ($array['folio_avance'] == "100") {
          $status = 5;
        }elseif ($statusActual['folio_avance'] < 100) {
          $status = 3;
        }
        $datos = array('id_folio' => $array['id_folio'],
                        'folio_avance' => $array['folio_avance'],
                        'fk_id_status_folio' => $status,
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $coment,
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo,
                        'fk_id_folio' => $array['id_folio']);
        $respuesta = ControladorFolios::ctrUpdateAvanceFolio($datos);
        if ($respuesta == "ok") {
          #insertar Log en tbl_historial_movimientos
          $log = ControladorFolios::ctrHistorialMovimientos($datos);
          echo json_encode($log);
        }else {
            echo json_encode($respuesta);
        }
    }
    public function ajaxUpdateInfoEquipo(){
        $array = json_decode($this->datos, true);
        $status;
        $movimiento = "Asignación de información de equipo";
        $coment = "Informacion: Modelo: " . $array['folio_modelo'] . "Marca: " . $array['folio_marca'] . " No de serie: " . $array['folio_numero_serie'] . " Equipo: " . $array['folio_equipo'];
        $modulo = "folioAdmin - Información Equipo";
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;

        #obtener el status actual del folio
        $item = "id_folio";
        $statusActual = ControladorFolios::ctrGetFoliosAJAX($item,$array['id_folio']);
        if ($statusActual['fk_id_status_folio'] == "1" || $statusActual['fk_id_status_folio'] == "2" || $statusActual['fk_id_status_folio'] == "4") {
            $status = 3;
        }else {
          $status = $statusActual['fk_id_status_folio'];
        }

        $datos = array('id_folio' => $array['id_folio'],

                        'folio_modelo' => $array['folio_modelo'],
                        'folio_marca' => $array['folio_marca'],
                        'folio_numero_serie' => $array['folio_numero_serie'],
                        'folio_equipo' => $array['folio_equipo'],

                        'fk_id_status_folio' => $status,
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $coment,
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo,
                        'fk_id_folio' => $array['id_folio']);
        $respuesta = ControladorFolios::ctrUpdateInfoEquipo($datos);
        if ($respuesta == "ok") {
          #insertar Log en tbl_historial_movimientos
          $log = ControladorFolios::ctrHistorialMovimientos($datos);
          echo json_encode($log);
        }else {
            echo json_encode($respuesta);
        }
    }
    public function ajaxInsertOrUpdateMaterial(){
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $modulo = "folioAdmin - Gastos Efectuados/Materiales";
        $array = json_decode($this->datos, true);
          if( (int) $array['id_requi_material'] > 0){
            // Edit
            $movimiento = "Actualización de Material";
            $coment = "Se cambian datos del material con ID ". $array['id_requi_material'];
            $datos = array('id_requi_material' => $array['id_requi_material'],
                            'fk_id_folio' => $array['fk_id_folio'],
                            'requiM_unidad_medida' => $array['requiM_unidad_medida'],
                            'requiM_descripcion' => $array['requiM_descripcion'],
                            'requiM_cantidad' => $array['requiM_cantidad'],
                            'requiM_importe_mxn' => $array['requiM_importe_mxn'],
                            'requiM_total_mxn' => $array['requiM_total_mxn'],
                            'requiM_moneda' => $array['requiM_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiM_importe_usd' => $array['requiM_importe_usd'],
                            'requiM_total_usd' => $array['requiM_total_usd'],
                            'requiM_solicitante' => $array['_us_name_'],
                            'requiM_fecha' => $fechaActual,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $edit = ControladorFolios::ctrUpdateMaterialAjax($datos);
            if ($edit == "EditOK") {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
              echo json_encode($edit);
            }else {
              echo json_encode($edit);
            }
          }else {
            // Insert
            $ET = 1;
            $movimiento = "Alta de nuevo Material";
            $coment = "Se agrega nuevo material con la siguente descipción: " . $array['requiM_descripcion'] . " y monto de " . $array['requiM_total_mxn'];
            $datos = array('fk_id_folio' => $array['fk_id_folio'],
                            'requiM_unidad_medida' => $array['requiM_unidad_medida'],
                            'requiM_descripcion' => $array['requiM_descripcion'],
                            'requiM_cantidad' => $array['requiM_cantidad'],
                            'requiM_importe_mxn' => $array['requiM_importe_mxn'],
                            'requiM_total_mxn' => $array['requiM_total_mxn'],
                            'requiM_moneda' => $array['requiM_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiM_importe_usd' => $array['requiM_importe_usd'],
                            'requiM_total_usd' => $array['requiM_total_usd'],
                            'requiM_solicitante' => $array['_us_name_'],
                            'requiM_fecha' => $fechaActual,
                            'requiM_estimado_tarde' => $ET,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $respuesta = ControladorFolios::ctrInsertMaterialesAjax($datos);
            if ($respuesta) {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
              echo json_encode($respuesta);

          }
    }
    public function ajaxGetMaterialReal(){
        $item = "id_requi_material";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetMaterialesReales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxEnviarAprobacion(){
        $array = json_decode($this->datos, true);
        $status = "Por Aprobación";
        $modulo = "folioAdmin - Gastos Efectuados/Materiales";
        $bandera = "True";
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        if ($array['modulo'] == "materiales") {
          // cambia status en tbl_requi_material
          $movimiento = "Enviar a aprobación";
          $coment = "Partida individual es enviada a Gerente ID: " . $array['id_requi_material'];
          $Datos = array('id_requi_material' => $array['id_requi_material'],
                          'requiM_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo'],
                          'folio_bandera' => $bandera);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
          }
          echo json_encode($respuesta);
        }elseif ($array['modulo'] == "manoDeObra") {
          // cambia status en tbl_requi_material
          $movimiento = "Enviar a aprobación";
          $coment = "Partida individual es enviada a Gerente ID " . $array['id_requi_material'];
          $Datos = array('id_requi_MdeObra' => $array['id_requi_material'],
                          'requiMO_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo'],
                          'folio_bandera' => $bandera);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
        }
        echo json_encode($respuesta);
      }elseif ($array['modulo'] == "externos") {
        // cambia status en tbl_requi_material
        $movimiento = "Enviar a aprobación";
        $coment = "Partida individual es enviada a Gerente ID " . $array['id_requi_material'];
        $Datos = array('id_requi_externo' => $array['id_requi_material'],
                        'requiE_status' => $status,
                        #para tbl_historial_movimientos
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $coment,
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo,
                        'fk_id_folio' => $array['fk_id_folio'],
                        'modulo' => $array['modulo'],
                        'folio_bandera' => $bandera);
        $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
        if ($respuesta == "ok") {
          #insertar Log en tbl_historial_movimientos
          $log = ControladorFolios::ctrHistorialMovimientos($Datos);
      }
      echo json_encode($respuesta);
      }
    }
    public function ajaxCancelarPartida(){
        $array = json_decode($this->datos, true);
        $status = "Cancelado";

        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $bandera = "True";
        if ($array['modulo'] == "materiales") {
          $modulo = "folioAdmin - Gastos Efectuados/Materiales";
          // cambia status en tbl_requi_material
          $movimiento = "Cancelación de Material";
          $coment = "Partida individual es Cancelada con ID " . $array['id_requi_material'];
          $Datos = array('id_requi_material' => $array['id_requi_material'],
                          'requiM_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo'],
                          'folio_bandera' => $bandera);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
            $changeBandera = ControladorFolios::ctrCambiarStatusFolio($Datos);
          }
          echo json_encode($respuesta);
        }elseif ($array['modulo'] == "manoDeObra") {
          // cambia status en tbl_requi_material
          $modulo = "folioAdmin - Gastos Efectuados/Mano de Obra";
          $movimiento = "Cancelación Mano de Obra";
          $coment = "Partida individual es Cancelada con ID " . $array['id_requi_material'];
          $Datos = array('id_requi_MdeObra' => $array['id_requi_material'],
                          'requiMO_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo'],
                          'folio_bandera' => $bandera);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
            $changeBandera = ControladorFolios::ctrCambiarStatusFolio($Datos);
          }
          echo json_encode($respuesta);
        }elseif ($array['modulo'] == "externos") {
          // cambia status en tbl_requi_material
          $modulo = "folioAdmin - Gastos Efectuados/Gastos Externos";
          $movimiento = "Cancelación gasto externo";
          $coment = "Partida individual es Cancelada con ID " . $array['id_requi_material'];
          $Datos = array('id_requi_externo' => $array['id_requi_material'],
                          'requiE_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo'],
                          'folio_bandera' => $bandera);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
            $changeBandera = ControladorFolios::ctrCambiarStatusFolio($Datos);
          }
          echo json_encode($respuesta);
        }elseif ($array['modulo'] == "AdicionalIndirecto") {
          // cambia status en tbl_requi_material
          $modulo = "folioAdmin - Gastos Efectuados/Gastos Internos";

          $movimiento = "Cancelación gasto Indirecto";
          $coment = "Partida individual es Cancelada con ID " . $array['id_requi_material'];
          $Datos = array('id_aIndirecto' => $array['id_requi_material'],
                          'adicionalInd_status' => $status,
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'fk_id_folio' => $array['fk_id_folio'],
                          'modulo' => $array['modulo']);
          $respuesta = ControladorFolios::ctrCambiarStatusPartida($Datos);
          if ($respuesta == "ok") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($Datos);
          }
          echo json_encode($respuesta);
        }
    }
    public function ajaxInsertarManoDeObra(){
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $modulo = "folioAdmin - Gastos Efectuados/Mano de Obra";
        $array = json_decode($this->datos, true);
          if( (int) $array['id_requi_MdeObra'] > 0){
            // Edit
            $movimiento = "Actualización de Mano de Obra";
            $coment = "Se cambian datos de registro con ID ". $array['id_requi_MdeObra'];
            $datos = array('id_requi_MdeObra' => $array['id_requi_MdeObra'],
                            'fk_id_folio' => $array['fk_id_folio'],
                            'requiMO_unidad_medida' => $array['requiMO_unidad_medida'],#ya
                            'requiMO_descripcion' => $array['requiMO_descripcion'], #ya
                            'requiMO_cantidad' => $array['requiMO_cantidad'], #ya
                            'requiMO_importe_mxn' => $array['requiMO_importe_mxn'], #ya
                            'requiMO_total_mxn' => $array['requiMO_total_mxn'], #ya
                            'requiMO_moneda' => $array['requiMO_moneda'],#ya
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiMO_importe_usd' => $array['requiMO_importe_usd'], #ya
                            'requiMO_total_usd' => $array['requiMO_total_usd'], #ya
                            'requiMO_solicitante' => $array['_us_name_'], #ya
                            'requiMO_fecha' => $fechaActual,#ya
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $edit = ControladorFolios::ctrUpdateManoDeObraAjax($datos);
            if ($edit == "EditOK") {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
              echo json_encode($edit);

          }else {
            // Insert
            $ET = 1;
            $movimiento = "Alta de nuevo registro de Mano de Obra";
            $coment = "Se agrega nuevo registro de Mano de Obra con la siguente descipción: " . $array['requiMO_descripcion'] . " y monto de " . $array['requiMO_total_mxn'];
            $datos = array('fk_id_folio' => $array['fk_id_folio'],
                            'requiMO_unidad_medida' => $array['requiMO_unidad_medida'],
                            'requiMO_descripcion' => $array['requiMO_descripcion'],
                            'requiMO_cantidad' => $array['requiMO_cantidad'],
                            'requiMO_importe_mxn' => $array['requiMO_importe_mxn'],
                            'requiMO_total_mxn' => $array['requiMO_total_mxn'],
                            'requiMO_moneda' => $array['requiMO_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiMO_importe_usd' => $array['requiMO_importe_usd'],
                            'requiMO_total_usd' => $array['requiMO_total_usd'],
                            'requiMO_solicitante' => $array['_us_name_'],
                            'requiMO_fecha' => $fechaActual,
                            'requiMO_estimado_tarde' => $ET,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $respuesta = ControladorFolios::ctrInsertManoDeObraAjax($datos);
            if ($respuesta == "insert") {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
              echo json_encode($respuesta);
          }
    }
    public function ajaxGetManoDeObraReal(){
        $item = "id_requi_MdeObra";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetManodeObraReales($item, $valor);
        echo json_encode($respuesta);
    }
    /*=============================================
      RECIBE EL ARRAY PARA INSERTAR DENTRO DE LA TABLA tbl_materiales
    =============================================*/
    public function ajaxInsertarIndirectos(){
      date_default_timezone_set("US/Central");
       $fecha = date('Y-m-d');
       $hora = date('H:i:s');
       $fechaActual = $fecha.' '.$hora;
       $modulo = "folioAdmin - Gastos Efectuados/ Adicionales-Gastos Indirectos";
       $array = json_decode($this->datos, true);

          if( (int) $array['id_aIndirecto'] > 0){
            // Edit
            $movimiento = "Actualización de adicionales-Gastos Indirectos";
            $coment = "Se cambian datos de registro con ID ". $array['id_aIndirecto'];
            $datos = array('id_aIndirecto' => $array['id_aIndirecto'],
                            'fk_id_folio' => $array['fk_id_folio'],
                            'adicionalesInd_unidad_medida' => $array['adicionalesInd_unidad_medida'],
                            'adicionalInd_descripcion' => $array['adicionalInd_descripcion'],
                            'adicionalInd_cantidad' => $array['adicionalInd_cantidad'],
                            'adicionalInd_importe_mxn' => $array['adicionalInd_importe_mxn'],
                            'adicionalInd_total_mxn' => $array['adicionalInd_total_mxn'],
                            'adicionalesInd_moneda' => $array['adicionalesInd_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'adicionalInd_importe_usd' => $array['adicionalInd_importe_usd'],
                            'adicionalInd_total_usd' => $array['adicionalInd_total_usd'],
                            'adicionalesInd_fecha' => $fechaActual,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['user_name'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $edit = ControladorFolios::ctrEditarIndirectosAjax($datos);
            if ($edit == "EditOK") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
            echo json_encode($edit);
          }else {
            // Insert
            $ET = 1;
            $movimiento = "Alta de nuevo registro adicionacional de gasto indirecto";
            $coment = "Se agrega nuevo registro de Adicional-Gasto Indirecto con la siguente descipción: " . $array['adicionalInd_descripcion'] . " y monto de " . $array['adicionalInd_total_mxn'];
            $datos = array('fk_id_folio' => $array['fk_id_folio'],
                            'adicionalesInd_unidad_medida' => $array['adicionalesInd_unidad_medida'],
                            'adicionalInd_descripcion' => $array['adicionalInd_descripcion'],
                            'adicionalInd_cantidad' => $array['adicionalInd_cantidad'],
                            'adicionalInd_importe_mxn' => $array['adicionalInd_importe_mxn'],
                            'adicionalInd_total_mxn' => $array['adicionalInd_total_mxn'],
                            'adicionalesInd_moneda' => $array['adicionalesInd_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'adicionalInd_importe_usd' => $array['adicionalInd_importe_usd'],
                            'adicionalInd_total_usd' => $array['adicionalInd_total_usd'],
                            'adicionalesInd_fecha' => $fechaActual,
                            'adicionalInd_estimado_tarde' => $ET,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['user_name'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $respuesta = ControladorFolios::ctrInsertarIndirectosAjax($datos);

            if ($respuesta == "insert") {
            #insertar Log en tbl_historial_movimientos
            $log = ControladorFolios::ctrHistorialMovimientos($datos);
          }
            echo json_encode($respuesta);
        }
    }
    public function ajaxGetAdicionalR(){
        $item = "id_aIndirecto";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetIndirectosAdicionales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxInsertOrUpdateExternos(){
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $modulo = "folioAdmin - Gastos Efectuados/Externos";
        $array = json_decode($this->datos, true);
          if( (int) $array['id_requi_externo'] > 0){
            // Edit
            $movimiento = "Actualización de gasto externo";
            $coment = "Se cambian datos del gasto externo con ID ". $array['id_requi_externo'];
            $datos = array('id_requi_externo' => $array['id_requi_externo'],
                            'fk_id_folio' => $array['fk_id_folio'],
                            'requiE_unidad_medida' => $array['requiE_unidad_medida'],
                            'requiE_descripcion' => $array['requiE_descripcion'],
                            'requiE_cantidad' => $array['requiE_cantidad'],
                            'requiE_importe_mxn' => $array['requiE_importe_mxn'],
                            'requiE_total_mxn' => $array['requiE_total_mxn'],
                            'requiE_moneda' => $array['requiE_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiE_importe_usd' => $array['requiE_importe_usd'],
                            'requiE_total_usd' => $array['requiE_total_usd'],
                            'requiE_solicitante' => $array['_us_name_'],
                            'requiE_fecha' => $fechaActual,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $edit = ControladorFolios::ctrUpdateExternosAjax($datos);
            if ($edit == "EditOK") {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);

            }
              echo json_encode($edit);
          }else {
            // Insert
            $ET = 1;
            $movimiento = "Alta de nuevo gasto Externo";
            $coment = "Se agrega nuevo material con la siguente descipción: " . $array['requiE_descripcion'] . " y monto de " . $array['requiE_total_mxn'];
            $datos = array('fk_id_folio' => $array['fk_id_folio'],
                            'requiE_unidad_medida' => $array['requiE_unidad_medida'],
                            'requiE_descripcion' => $array['requiE_descripcion'],
                            'requiE_cantidad' => $array['requiE_cantidad'],
                            'requiE_importe_mxn' => $array['requiE_importe_mxn'],
                            'requiE_total_mxn' => $array['requiE_total_mxn'],
                            'requiE_moneda' => $array['requiE_moneda'],
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas'],
                            'requiE_importe_usd' => $array['requiE_importe_usd'],
                            'requiE_total_usd' => $array['requiE_total_usd'],
                            'requiE_solicitante' => $array['_us_name_'],
                            'requiE_fecha' => $fechaActual,
                            'requiE_estimado_tarde' => $ET,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['_us_name_'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio']);
            $respuesta = ControladorFolios::ctrInsertExternosAjax($datos);
            if ($respuesta) {
              #insertar Log en tbl_historial_movimientos
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
              echo json_encode($respuesta);
          }
    }
    public function ajaxGetExternoReal(){
        $item = "id_requi_externo";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetExternosReales($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetNotification(){

        $respuesta = ControladorFolios::ctrGetNotification();
        echo json_encode($respuesta);
    }
    public function ajaxGetFoliosPendientes(){
      $respuesta = ControladorFolios::ctrGetFoliosPendientes();
  //    var_dump($respuesta);exit;
      echo json_encode($respuesta);
    }
    public function ajaxAprobarPartida(){
          $array = json_decode($this->datos, true);
          $status = "Aprobado";
          $bandera = "False";
          date_default_timezone_set("US/Central");
          $fecha = date('Y-m-d');
          $hora = date('H:i:s');
          $fechaActual = $fecha.' '.$hora;
          if ($array['modulo'] == "materiales") {
            $modulo = "folioAdmin - Gastos Efectuados/Materiales";
            // cambia status en tbl_requi_material
            $movimiento = "Aprobación de Material";
            $coment = "Partida individual Aprobada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
            $Datos = array('id_requi_material' => $array['id_requi_material'],
                            'requiM_status' => $status,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['user_name'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $coment,
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio'],
                            'modulo' => $array['modulo'],
                            'folio_bandera' => $bandera,
                            'soli_cantidad_piezas' => $array['soli_cantidad_piezas']);
            $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
            if ($respuesta == "ok") {
              #insertar Log en tbl_historial_movimientos
              $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
              $log = ControladorFolios::ctrHistorialMovimientos($Datos);
              #Aplicar sumatoria de producto a gasto de folio
              $aplicarGasto = ControladorFolios::ctrAplicarGastoMaterialFolio($Datos);
          }
          echo json_encode($respuesta);
          }elseif ($array['modulo'] == "manoDeObra") {
                // cambia status en tbl_requi_material
                  $modulo = "folioAdmin - Gastos Efectuados/Mano de Obra";
                  $movimiento = "Aprobación de Mano de Obra";
                  $coment = "Partida individual Aprobada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
                  $Datos = array('id_requi_MdeObra' => $array['id_requi_material'],
                                  'requiMO_status' => $status,
                                  #para tbl_historial_movimientos
                                  'historial_creadoPor' => $array['user_name'],
                                  'historial_movimiento' => $movimiento,
                                  'historial_comentario' => $coment,
                                  'historial_fecha_registro' => $fechaActual,
                                  'historial_modulo' => $modulo,
                                  'fk_id_folio' => $array['fk_id_folio'],
                                  'modulo' => $array['modulo'],
                                  'folio_bandera' => $bandera,
                                  'soli_cantidad_piezas' => $array['soli_cantidad_piezas']);
                  $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
                  if ($respuesta == "ok") {
                    #insertar Log en tbl_historial_movimientos
                    $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
                    $log = ControladorFolios::ctrHistorialMovimientos($Datos);
                    #Aplicar sumatoria de producto a gasto de folio
                    $aplicarGasto = ControladorFolios::ctrAplicarGastoFolio($Datos);
                }
                echo json_encode($respuesta);
            }elseif ($array['modulo'] == "externos") {
              // cambia status en tbl_requi_material
                $modulo = "folioAdmin - Gastos Efectuados/Gastos Externo";
                $movimiento = "Aprobación de Gasto Externo";
                $coment = "Partida individual Aprobada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
                $Datos = array('id_requi_externo' => $array['id_requi_material'],
                                'requiE_status' => $status,
                                #para tbl_historial_movimientos
                                'historial_creadoPor' => $array['user_name'],
                                'historial_movimiento' => $movimiento,
                                'historial_comentario' => $coment,
                                'historial_fecha_registro' => $fechaActual,
                                'historial_modulo' => $modulo,
                                'fk_id_folio' => $array['fk_id_folio'],
                                'modulo' => $array['modulo'],
                                'folio_bandera' => $bandera,
                                'soli_cantidad_piezas' => $array['soli_cantidad_piezas']);
                $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
                if ($respuesta == "ok") {
                  #insertar Log en tbl_historial_movimientos
                  $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
                  $log = ControladorFolios::ctrHistorialMovimientos($Datos);
                  $aplicarGasto = ControladorFolios::ctrAplicarGastoExternoFolio($Datos);
              }
              echo json_encode($respuesta);
          }
    }
    public function ajaxRechazarPartida(){
          $array = json_decode($this->datos, true);
          $status = "Rechazado";

          $bandera = "False";

          date_default_timezone_set("US/Central");
          $fecha = date('Y-m-d');
          $hora = date('H:i:s');
          $fechaActual = $fecha.' '.$hora;
          if ($array['modulo'] == "materiales") {
            $modulo = "folioAdmin - Rechazo en Gastos Efectuados/Materiales";
            // cambia status en tbl_requi_material
            $movimiento = "Rechazo de Material";
          //  $coment = "Partida individual rechazada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
            $Datos = array('id_requi_material' => $array['id_requi_material'],
                            'requiM_status' => $status,
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['user_name'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $array['historial_comentario'],
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo,
                            'fk_id_folio' => $array['fk_id_folio'],
                            'modulo' => $array['modulo'],
                            'folio_bandera' => $bandera);
            $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
            if ($respuesta == "ok") {
              #insertar Log en tbl_historial_movimientos
              $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
              $log = ControladorFolios::ctrHistorialMovimientos($Datos);
          }
          echo json_encode($respuesta);
          }elseif ($array['modulo'] == "manoDeObra") {
                $modulo = "folioAdmin - Rechazo en Gastos Efectuados/Mano De Obra";
                // cambia status en tbl_requi_material
                $movimiento = "Rechazo de Mano de Obra";
                $coment = "Partida individual Aprobada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
                $Datos = array('id_requi_MdeObra' => $array['id_requi_material'],
                                  'requiMO_status' => $status,
                                  #para tbl_historial_movimientos
                                  'historial_creadoPor' => $array['user_name'],
                                  'historial_movimiento' => $movimiento,
                                  'historial_comentario' => $array['historial_comentario'],
                                  'historial_fecha_registro' => $fechaActual,
                                  'historial_modulo' => $modulo,
                                  'fk_id_folio' => $array['fk_id_folio'],
                                  'modulo' => $array['modulo'],
                                  'folio_bandera' => $bandera);
                  $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
                  if ($respuesta == "ok") {
                    #insertar Log en tbl_historial_movimientos
                    $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
                    $log = ControladorFolios::ctrHistorialMovimientos($Datos);
                }
                echo json_encode($respuesta);
            }elseif ($array['modulo'] == "externos") {
                $modulo = "folioAdmin -  Rechazo en Gastos Efectuados/Externos";
              // cambia status en tbl_requi_material
                $movimiento = "Rechazo de gasto Externo";
                $coment = "Partida individual Aprobada ID: " . $array['id_requi_material'] . " Por Usuario: " . $array['user_name'] ;
                $Datos = array('id_requi_externo' => $array['id_requi_material'],
                                'requiE_status' => $status,
                                #para tbl_historial_movimientos
                                'historial_creadoPor' => $array['user_name'],
                                'historial_movimiento' => $movimiento,
                                'historial_comentario' => $array['historial_comentario'],
                                'historial_fecha_registro' => $fechaActual,
                                'historial_modulo' => $modulo,
                                'fk_id_folio' => $array['fk_id_folio'],
                                'modulo' => $array['modulo'],
                                'folio_bandera' => $bandera);
                $respuesta = ControladorFolios::ctrAprobarORechazarPartida($Datos);
                if ($respuesta == "ok") {
                  #insertar Log en tbl_historial_movimientos
                  $changeB = ControladorFolios::ctrCambiarStatusFolio($Datos);
                  $log = ControladorFolios::ctrHistorialMovimientos($Datos);
              }
              echo json_encode($respuesta);
          }
    }
    public function ajaxComentRechazos(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetComentariosDeRechazo($item, $valor);
        echo json_encode($respuesta);
    }
    public function ajaxGetStatusFolio(){
        $respuesta = ControladorFolios::ctrGetStatusFolio();
        echo json_encode($respuesta);
    }
    public function ajaxCambiarStatusFolio(){
        $array = json_decode($this->datos, true);
        if ($array['modulo'] == "En Proceso") {
            $movimiento = "Cambio de Status a En Proceso";
            // Cambiar status de folio
            date_default_timezone_set("US/Central");
            $fecha = date('Y-m-d');
            $hora = date('H:i:s');
            $fechaActual = $fecha.' '.$hora;
            $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
            $modulo = "folioAdmin - Seguimiento de Folio";
            $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                           'fk_id_folio' => $array['fk_id_folio'],
                           #para tbl_historial_movimientos
                           'historial_creadoPor' => $array['user_name'],
                           'historial_movimiento' => $movimiento,
                           'historial_comentario' => $coment,
                           'historial_fecha_registro' => $fechaActual,
                           'historial_modulo' => $modulo);
           $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
           if ($cambiaStatus == "ok") {
             $log = ControladorFolios::ctrHistorialMovimientos($datos);
           }
           echo json_encode($cambiaStatus);
         }elseif ($array['modulo'] == "Detenido") {
             $movimiento = "Cambio de Status a Detenido";
             date_default_timezone_set("US/Central");
             $fecha = date('Y-m-d');
             $hora = date('H:i:s');
             $fechaActual = $fecha.' '.$hora;
            // $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'] . " Por el usuario: " . $array['user_name'];
             $modulo = "folioAdmin - Seguimiento de Folio";
             $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                            'fk_id_folio' => $array['fk_id_folio'],
                            #para tbl_historial_movimientos
                            'historial_creadoPor' => $array['user_name'],
                            'historial_movimiento' => $movimiento,
                            'historial_comentario' => $array['comentario'],
                            'historial_fecha_registro' => $fechaActual,
                            'historial_modulo' => $modulo);
            $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
            if ($cambiaStatus == "ok") {
              $log = ControladorFolios::ctrHistorialMovimientos($datos);
            }
            echo json_encode($cambiaStatus);
         }elseif ($array['modulo'] == "Terminado") {
           $movimiento = "Cambio de Status a Terminado";
           // Cambiar status de folio
           date_default_timezone_set("US/Central");
           $fecha = date('Y-m-d');
           $hora = date('H:i:s');
           $fechaActual = $fecha.' '.$hora;
           $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
           $modulo = "folioAdmin - Seguimiento de Folio";
           $avance = "100";
           $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                          'fk_id_folio' => $array['fk_id_folio'],
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo,
                          'folio_avance' => $avance,
                          'id_folio' => $array['fk_id_folio']);
          $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
          $cambiarAvance = ControladorFolios::ctrUpdateAvanceFolio($datos);
          if ($cambiaStatus == "ok") {
            $log = ControladorFolios::ctrHistorialMovimientos($datos);
          }
          echo json_encode($cambiaStatus);
        }elseif ($array['modulo'] == "Entregado") {
          $movimiento = "Cambio de Status a Entregado";
          // Cambiar status de folio
          date_default_timezone_set("US/Central");
          $fecha = date('Y-m-d');
          $hora = date('H:i:s');
          $fechaActual = $fecha.' '.$hora;
          $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
          $modulo = "folioAdmin - Seguimiento de Folio";
          $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                         'fk_id_folio' => $array['fk_id_folio'],
                         #para tbl_historial_movimientos
                         'historial_creadoPor' => $array['user_name'],
                         'historial_movimiento' => $movimiento,
                         'historial_comentario' => $coment,
                         'historial_fecha_registro' => $fechaActual,
                         'historial_modulo' => $modulo);
         $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
         if ($cambiaStatus == "ok") {
           $log = ControladorFolios::ctrHistorialMovimientos($datos);
         }
         echo json_encode($cambiaStatus);
       }elseif ($array['modulo'] == "Evaluación") {
           $movimiento = "Cambio de Status a Evaluación";
           // Cambiar status de folio
           date_default_timezone_set("US/Central");
           $fecha = date('Y-m-d');
           $hora = date('H:i:s');
           $fechaActual = $fecha.' '.$hora;
           $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
           $modulo = "folioAdmin - Seguimiento de Folio";
           $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                          'fk_id_folio' => $array['fk_id_folio'],
                          #para tbl_historial_movimientos
                          'historial_creadoPor' => $array['user_name'],
                          'historial_movimiento' => $movimiento,
                          'historial_comentario' => $coment,
                          'historial_fecha_registro' => $fechaActual,
                          'historial_modulo' => $modulo);
          $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
          if ($cambiaStatus == "ok") {
            $log = ControladorFolios::ctrHistorialMovimientos($datos);
          }
          echo json_encode($cambiaStatus);
       }elseif ($array['modulo'] == "Cobrado") {
         $movimiento = "Cambio de Status a Cobrados";
         // Cambiar status de folio
         date_default_timezone_set("US/Central");
         $fecha = date('Y-m-d');
         $hora = date('H:i:s');
         $fechaActual = $fecha.' '.$hora;
         $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
         $modulo = "folioAdmin - Seguimiento de Folio";
         $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                        'fk_id_folio' => $array['fk_id_folio'],
                        #para tbl_historial_movimientos
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $coment,
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo);
        $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
        if ($cambiaStatus == "ok") {
          $log = ControladorFolios::ctrHistorialMovimientos($datos);
        }
        echo json_encode($cambiaStatus);
      }elseif ($array['modulo'] == "Facturado") {
        $movimiento = "Cambio de Status a Facturado";
        // Cambiar status de folio
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
        $modulo = "folioAdmin - Seguimiento de Folio";
        $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                       'fk_id_folio' => $array['fk_id_folio'],
                       #para tbl_historial_movimientos
                       'historial_creadoPor' => $array['user_name'],
                       'historial_movimiento' => $movimiento,
                       'historial_comentario' => $coment,
                       'historial_fecha_registro' => $fechaActual,
                       'historial_modulo' => $modulo);
       $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
       if ($cambiaStatus == "ok") {
         $log = ControladorFolios::ctrHistorialMovimientos($datos);
       }
       echo json_encode($cambiaStatus);
     }elseif ($array['modulo'] == "Rechazado") {
       $movimiento = "Cambio de Status a Rechazado";
       date_default_timezone_set("US/Central");
       $fecha = date('Y-m-d');
       $hora = date('H:i:s');
       $fechaActual = $fecha.' '.$hora;
      // $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'] . " Por el usuario: " . $array['user_name'];
       $modulo = "folioAdmin - Seguimiento de Folio";
       $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                      'fk_id_folio' => $array['fk_id_folio'],
                      #para tbl_historial_movimientos
                      'historial_creadoPor' => $array['user_name'],
                      'historial_movimiento' => $movimiento,
                      'historial_comentario' => $array['comentario'],
                      'historial_fecha_registro' => $fechaActual,
                      'historial_modulo' => $modulo);
       $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
       if ($cambiaStatus == "ok") {
        $log = ControladorFolios::ctrHistorialMovimientos($datos);
       }
       echo json_encode($cambiaStatus);
     }elseif ($array['modulo'] == "Cancelado") {
       $movimiento = "Cambio de Status a Cancelado";
       date_default_timezone_set("US/Central");
       $fecha = date('Y-m-d');
       $hora = date('H:i:s');
       $fechaActual = $fecha.' '.$hora;
       $modulo = "folioAdmin - Seguimiento de Folio";
       $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                     'fk_id_folio' => $array['fk_id_folio'],
                     #para tbl_historial_movimientos
                     'historial_creadoPor' => $array['user_name'],
                     'historial_movimiento' => $movimiento,
                     'historial_comentario' => $array['comentario'],
                     'historial_fecha_registro' => $fechaActual,
                     'historial_modulo' => $modulo);
       $cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
       if ($cambiaStatus == "ok") {
        $log = ControladorFolios::ctrHistorialMovimientos($datos);
       }
       echo json_encode($cambiaStatus);
     }elseif ($array['modulo'] == "No Reparado") {
       $movimiento = "Cambio de Status a No Reparado";
       // Cambiar status de folio
       date_default_timezone_set("US/Central");
       $fecha = date('Y-m-d');
       $hora = date('H:i:s');
       $fechaActual = $fecha.' '.$hora;
       $coment = "Cambio en el status del folio con ID: " . $array['fk_id_folio'];
       $modulo = "folioAdmin - Seguimiento de Folio";
       $avance = 0;
       $datos = array('fk_id_status_folio' => $array['fk_id_status_folio'],
                      'fk_id_folio' => $array['fk_id_folio'],
                      'folio_avance' => $avance,
                      'id_folio' => $array['fk_id_folio'],
                      #para tbl_historial_movimientos
                      'historial_creadoPor' => $array['user_name'],
                      'historial_movimiento' => $movimiento,
                      'historial_comentario' => $coment,
                      'historial_fecha_registro' => $fechaActual,
                      'historial_modulo' => $modulo);
      #Se cambia status de la solicitud y se regresa el avance a 0
      $cambiaStatus = ControladorFolios::ctrUpdateAvanceFolio($datos);
      #$cambiaStatus = ControladorFolios::ctrChangeStatusFolio($datos);
      if ($cambiaStatus == "ok") {
        $log = ControladorFolios::ctrHistorialMovimientos($datos);
      }
      echo json_encode($cambiaStatus);
    }
    }#Fin de function
    public function ajaxHistorialFolio(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetHistorialFolio($item, $valor);
        echo json_encode($respuesta);
    }#Fin de function
    public function ajaxGenerarRM(){
      date_default_timezone_set("US/Central");
      $fecha = date('Y-m-d');
      $hora = date('H:i:s');
      $fechaActual = $fecha.' '.$hora;
      $folioRM = ControladorFolios::ctrGetFolioRM();
      $array = json_decode($this->datos, true);
      $datos = array('fk_id_folio' => $array['fk_id_folio'],
                     'fk_id_solicitud' => $array['fk_id_solicitud'],
                     'rm_creado_por' => $array['rm_creado_por'],
                     'rm_fecha_creado' => $fechaActual,
                     'rm_folio' => $folioRM,
                     'fk_id_status_folio' => $array['fk_id_status_folio'],
                     'id_folio' => $array['fk_id_folio']);
      $respuesta = ControladorFolios::ctrGenerarRM($datos);
      $update = ControladorFolios::ctrUpdateStatuFolio($datos);
      echo json_encode($respuesta);
    }#Fin de function
    public function ajaxGetRM(){
        $item = "fk_id_folio";
        $valor = $this->dato;
        $respuesta = ControladorFolios::ctrGetRM($item, $valor);
        echo json_encode($respuesta);
    }#Fin de function
    public function ajaxUpdateOCorFactura(){
        $array = json_decode($this->datos, true);
        $movimiento = "Guardar No de orden de compra o No  de Factura";
        $coment = "Cambio en registro ID: " . $array['id_folio'];
        date_default_timezone_set("US/Central");
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        $fechaActual = $fecha.' '.$hora;
        $modulo = "folioAdmin - Factura";
        $status = 9;
        $datos = array('id_folio' => $array['id_folio'],
                       'id_solicitud' => $array['id_solicitud'],
                        'soli_orden_de_compra' => $array['soli_orden_de_compra'],
                        'folio_NoFactura' => $array['folio_NoFactura'],
                        'fk_id_status_folio' => $status,
                        #para tbl_historial_movimientos
                        'fk_id_folio' => $array['id_folio'],
                        'historial_creadoPor' => $array['user_name'],
                        'historial_movimiento' => $movimiento,
                        'historial_comentario' => $coment,
                        'historial_fecha_registro' => $fechaActual,
                        'historial_modulo' => $modulo);
        $solicitud = ControladorSolicitudes::ctrUpdateNoOC($datos);

        if ($solicitud == "ok") {

          if ($array['folio_NoFactura'] !== 0) {
            $folio = ControladorFolios::ctrUpdateNoFacturaConStatus($datos);
          }else {
            $folio = ControladorFolios::ctrUpdateNoFactura($datos);
          }
          if ($folio == "ok") {
            $log = ControladorFolios::ctrHistorialMovimientos($datos);
          }
          echo json_encode($folio);
        }else {
          echo json_encode($solicitud);
        }

    }#Fin de function
}
  /*=============================================
        OBTIENE DATOS POR POST
  =============================================*/
  if(isset($_POST["GetFolios_"])){
    $editar = new AjaxFolio();
    $editar -> ajaxGetFolios();
  }
  /*=============================================
      CARGAR LOS DETALLES DE LA SOLICITUD DENTRO DEL FORMJULARIO
    =============================================*/
  if(isset($_POST["_idSolicitud"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_idSolicitud"];
    $editar -> ajaxGetDatosDeSolicitud();
  }
  /*=============================================
        SE OBTIENEN TODOS LOS REGISTROS   DE MATERIAL REQUERIDO
    =============================================*/
  if(isset($_POST["_GetMaterialesR"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetMaterialesR"];
    $editar -> ajaxGetMaterialesReales();
  }
  /*=============================================
      SE OBTIENEN TODOS LOS REGISTROS   DE MATERIAL REQUERIDO
    =============================================*/
  if(isset($_POST["_GetManoR"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetManoR"];
    $editar -> ajaxGetManoDeObraReales();
  }
  /*=============================================
      SE OBTIENEN TODOS LOS REGISTROS   DE INDIRECTOS ADICIONALES
    =============================================*/
  if(isset($_POST["_GetIndirectosAdicionales"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetIndirectosAdicionales"];
    $editar -> ajaxGetIndirectosAdicionales();
  }
  /*=============================================
      SE OBTIENEN TODOS LOS REGISTROS   DE EXTERNOS ADICIONALES
    =============================================*/
  if(isset($_POST["_GetExternosR"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetExternosR"];
    $editar -> ajaxGetExternosReales();
  }
  /*=============================================
      SE OBTIENEN TODOS LOS REGISTROS   DE EXTERNOS ADICIONALES
    =============================================*/
  if(isset($_POST["saveNotasGenerales_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["saveNotasGenerales_"];
    $editar -> ajaxUpdateNotasGenerales();
  }
  /*=============================================
    MODIFICA EL AVANCE DEL FOLIO WHERE id_folio
    =============================================*/
  if(isset($_POST["saveAvanceFolio_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["saveAvanceFolio_"];
    $editar -> ajaxUpdateAvanceFolio();
  }
  /*=============================================
    MODIFICA LA INFORMACION DE EQUIPO WHERE FOLIO
    =============================================*/
  if(isset($_POST["saveInfoEquipo_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["saveInfoEquipo_"];
    $editar -> ajaxUpdateInfoEquipo();
  }
  /*=============================================
    INSERT OR UPADTE MATERIAL REAL
    =============================================*/
  if(isset($_POST["InsertarMateriales_R"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["InsertarMateriales_R"];
    $editar -> ajaxInsertOrUpdateMaterial();
  }
  /*=============================================
     GET A PARTIDA WHERE id_requi_material
    =============================================*/
  if(isset($_POST["GetMaterialR_"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["GetMaterialR_"];
    $editar -> ajaxGetMaterialReal();
  }
  /*=============================================
     CAMBIA STATUS DE LA PARTIDA A POR APROBACION
    =============================================*/
  if(isset($_POST["enviarAprobacion_"])){

    $editar = new AjaxFolio();
    $editar -> datos = $_POST["enviarAprobacion_"];
    $editar -> ajaxEnviarAprobacion();
  }
  /*=============================================
     CAMBIA STATUS DE LA PARTIDA A CANCELADA
    =============================================*/
  if(isset($_POST["CancelarPartida_"])){

    $editar = new AjaxFolio();
    $editar -> datos = $_POST["CancelarPartida_"];
    $editar -> ajaxCancelarPartida();
  }
  if(isset($_POST["InsertarManoDeObra"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["InsertarManoDeObra"];
    $editar -> ajaxInsertarManoDeObra();
  }
  /*=============================================
     GET A PARTIDA WHERE id_requi_MdeObra
    =============================================*/
  if(isset($_POST["GetManoDeObraR_"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["GetManoDeObraR_"];
    $editar -> ajaxGetManoDeObraReal();
  }

  /*=============================================
        SE INSERTA EL APARTADO DE ADICIONALES INDIRECTOS / UPDATE OR /INSERT
    =============================================*/
  if(isset($_POST["InsertarIndirectos"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["InsertarIndirectos"];
    $editar -> ajaxInsertarIndirectos();
  }
  /*=============================================
        obtiene gasto adicional where id_aIndirecto
    =============================================*/
  if(isset($_POST["GetAdicionalesR_"])){
    $editar = new AjaxFolio();
    $editar -> dato = $_POST["GetAdicionalesR_"];
    $editar -> ajaxGetAdicionalR();
  }
  /*=============================================
    INSERT OR UPADTE EXTERNOS
    =============================================*/
  if(isset($_POST["InsertarExternos_R"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["InsertarExternos_R"];
    $editar -> ajaxInsertOrUpdateExternos();
  }
  /*=============================================
     GET A PARTIDA WHERE id_requi_material
    =============================================*/
  if(isset($_POST["GetExternoR_"])){

    $editar = new AjaxFolio();
    $editar -> dato = $_POST["GetExternoR_"];
    $editar -> ajaxGetExternoReal();
  }
  /*=============================================
     ACTIVA FUNCION PARA CONTAR PARTIDAS PENDIENTES POR APROBAR
    =============================================*/
  if(isset($_POST["GetNotification_"])){

    $editar = new AjaxFolio();
    $editar -> ajaxGetNotification();
  }
  /*=============================================
        OBTIENE DATOS POR POST
  =============================================*/
  if(isset($_POST["GetFoliosPendientes_"])){
    $editar = new AjaxFolio();
    $editar -> ajaxGetFoliosPendientes();
  }
  /*=============================================
     CAMBIA STATUS DE LA PARTIDA A POR APROBACION
    =============================================*/
  if(isset($_POST["aprobarPartida_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["aprobarPartida_"];
    $editar -> ajaxAprobarPartida();
  }
  /*=============================================
     CAMBIA STATUS DE LA PARTIDA A POR APROBACION
    =============================================*/
  if(isset($_POST["rechazarPartida_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["rechazarPartida_"];
    $editar -> ajaxRechazarPartida();
  }
  /*=============================================
     CAMBIA STATUS DE LA PARTIDA A POR APROBACION
    =============================================*/
  if(isset($_POST["_GetComentRechazos"])){
    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetComentRechazos"];
    $editar -> ajaxComentRechazos();
  }
  /*=============================================
    OBTENER EL LISTADO DE STATUS CON SU ROL ASIGNADO
    =============================================*/
  if(isset($_POST["_GetStatusFolio"])){
    $editar = new AjaxFolio();
    $editar -> ajaxGetStatusFolio();
  }
  /*=============================================
    CAMBIAR EL STATUS DEL FOLIO
    =============================================*/
  if(isset($_POST["cambiarStatusFolio_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["cambiarStatusFolio_"];
    $editar -> ajaxCambiarStatusFolio();
  }
  /*=============================================
     MOSTRAR EL HISTORIAL DEL FOLIO
    =============================================*/
  if(isset($_POST["_GetHistorialFolio"])){
    $editar = new AjaxFolio();
    $editar -> dato = $_POST["_GetHistorialFolio"];
    $editar -> ajaxHistorialFolio();
  }
  /*=============================================
     GENERAR REMISION WHERE fk_id_folio
    =============================================*/
  if(isset($_POST["generarRM_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["generarRM_"];
    $editar -> ajaxGenerarRM();
  }
  if(isset($_POST["GetRM_"])){
    $editar = new AjaxFolio();
    $editar -> dato = $_POST["GetRM_"];
    $editar -> ajaxGetRM();
  }
  if(isset($_POST["UpdateOCorFactura_"])){
    $editar = new AjaxFolio();
    $editar -> datos = $_POST["UpdateOCorFactura_"];
    $editar -> ajaxUpdateOCorFactura();
  }


?>
